<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_init', 'pro_slider_wp_settings_init' );

function pro_slider_wp_settings_init() {
    register_setting( 'pro_slider_settings_group', 'pro_slider_settings', 'pro_slider_sanitize_settings' );

    add_settings_section( 'pro_slider_content_section', 'İçerik Kaynağı Ayarları', 'pro_slider_content_section_callback', 'pro_slider_content_page' );
    add_settings_field( 'slide_count', 'Slider Yazı Adedi', 'pro_slider_slide_count_render', 'pro_slider_content_page', 'pro_slider_content_section' );
    add_settings_field( 'slide_order', 'Slider Yazı Sıralaması', 'pro_slider_slide_order_render', 'pro_slider_content_page', 'pro_slider_content_section' );
    add_settings_field( 'categories', 'Slider Kategorileri', 'pro_slider_category_filter_render', 'pro_slider_content_page', 'pro_slider_content_section' );

    add_settings_section( 'pro_slider_design_section', 'Tasarım ve Boyutlandırma Ayarları', null, 'pro_slider_design_page' );
    add_settings_field( 'skin', 'Görünüm Teması', 'pro_slider_skin_render', 'pro_slider_design_page', 'pro_slider_design_section' );
    add_settings_field( 'magazine_grid_category', 'Dergi Stili Yan İçerik Kategorisi', 'pro_slider_magazine_category_render', 'pro_slider_design_page', 'pro_slider_design_section' );
    add_settings_field( 'slider_height', 'Slider Yüksekliği (px)', 'pro_slider_height_render', 'pro_slider_design_page', 'pro_slider_design_section' );
    add_settings_field( 'main_color', 'Ana Renk (Butonlar, vb.)', 'pro_slider_main_color_render', 'pro_slider_design_page', 'pro_slider_design_section' );
    add_settings_field( 'nav_color', 'Navigasyon Rengi (Oklar, Noktalar)', 'pro_slider_nav_color_render', 'pro_slider_design_page', 'pro_slider_design_section' );
    add_settings_field( 'thumbnail_frame_color', 'Küçük Resim Aktif Çerçeve Rengi', 'pro_slider_thumbnail_frame_color_render', 'pro_slider_design_page', 'pro_slider_design_section' );

    add_settings_section( 'pro_slider_nav_section', 'Navigasyon ve Efekt Ayarları', null, 'pro_slider_nav_page' );
    add_settings_field( 'autoplay', 'Otomatik Oynatma', 'pro_slider_autoplay_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
    add_settings_field( 'effect', 'Geçiş Efekti', 'pro_slider_effect_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
    add_settings_field( 'show_arrows', 'Navigasyon Okları', 'pro_slider_show_arrows_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
    add_settings_field( 'show_pagination', 'Sayfalama (Noktalar)', 'pro_slider_show_pagination_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
    add_settings_field( 'show_thumbnails', 'Küçük Resimli Navigasyon', 'pro_slider_show_thumbnails_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
    add_settings_field( 'thumbnail_count', 'Görünecek Küçük Resim Adedi', 'pro_slider_thumbnail_count_render', 'pro_slider_nav_page', 'pro_slider_nav_section' );
}

function pro_slider_content_section_callback() { echo '<p>Sliderda gösterilecek içeriklerin kaynağını ve davranışını buradan ayarlayın.</p>';}
function pro_slider_slide_count_render() { $options = get_option('pro_slider_settings'); $value = isset($options['slide_count']) ? $options['slide_count'] : 5; echo "<input type='number' name='pro_slider_settings[slide_count]' value='" . esc_attr($value) . "' min='1' max='20'>"; }
function pro_slider_slide_order_render() { $options = get_option('pro_slider_settings'); $value = isset($options['slide_order']) ? $options['slide_order'] : 'date_desc'; echo "<select name='pro_slider_settings[slide_order]'><option value='date_desc' ".selected($value, 'date_desc', false).">En Yeniye Göre</option><option value='date_asc' ".selected($value, 'date_asc', false).">En Eskiye Göre</option><option value='rand' ".selected($value, 'rand', false).">Rastgele</option></select>";}
function pro_slider_category_filter_render() { $options = get_option('pro_slider_settings'); $saved_cats = isset($options['categories']) && is_array($options['categories']) ? $options['categories'] : array(); $categories = get_categories(array('hide_empty' => false)); echo '<select name="pro_slider_settings[categories][]" multiple="multiple" class="pro-slider-select2" style="width: 100%; max-width: 400px;">'; foreach ($categories as $category) { $is_selected = in_array($category->term_id, $saved_cats); echo '<option value="' . esc_attr($category->term_id) . '" ' . selected($is_selected, true, false) . '>' . esc_html($category->name) . '</option>'; } echo '</select><p class="description">Ana slider\'da sadece burada seçtiğiniz kategorilerdeki yazılar gösterilir. Hiçbirini seçmezseniz tüm yazılar gösterilir.</p>';}
function pro_slider_skin_render() { $options = get_option('pro_slider_settings'); $value = isset($options['skin']) ? $options['skin'] : 'default'; echo "<select name='pro_slider_settings[skin]'><option value='default' ".selected($value, 'default', false).">Varsayılan (Kırmızı Tema)</option><option value='minimal-white' ".selected($value, 'minimal-white', false).">Minimalist Beyaz</option><option value='modern-dark' ".selected($value, 'modern-dark', false).">Modern Karanlık</option><option value='magazine-grid-light' ".selected($value, 'magazine-grid-light', false).">Dergi Stili (Açık)</option><option value='magazine-grid-dark' ".selected($value, 'magazine-grid-dark', false).">Dergi Stili (Koyu)</option></select>";}
function pro_slider_magazine_category_render() { $options = get_option('pro_slider_settings'); $value = isset($options['magazine_grid_category']) ? $options['magazine_grid_category'] : ''; $dropdown_args = array( 'show_option_none' => 'Kategori Seçin', 'name' => 'pro_slider_settings[magazine_grid_category]', 'selected' => $value, 'taxonomy' => 'category', 'echo' => 0 ); $dropdown = wp_dropdown_categories($dropdown_args); echo $dropdown; echo '<p class="description">"Dergi Stili" temalarından birini seçtiğinizde, sağdaki iki görsel bu kategoriden çekilecektir.</p>';}
function pro_slider_height_render() { $options = get_option('pro_slider_settings'); $value = isset($options['slider_height']) ? $options['slider_height'] : 500; echo "<input type='number' name='pro_slider_settings[slider_height]' value='" . esc_attr($value) . "' min='200' max='1200'><p class='description'>Standart temalar için geçerlidir. Dergi Stili teması yüksekliği otomatiktir.</p>";}
function pro_slider_main_color_render() { $options = get_option('pro_slider_settings'); $value = isset($options['main_color']) ? $options['main_color'] : '#E53935'; echo "<input type='color' name='pro_slider_settings[main_color]' value='" . esc_attr($value) . "'>";}
function pro_slider_nav_color_render() { $options = get_option('pro_slider_settings'); $value = isset($options['nav_color']) ? $options['nav_color'] : '#FFFFFF'; echo "<input type='color' name='pro_slider_settings[nav_color]' value='" . esc_attr($value) . "'>";}
function pro_slider_thumbnail_frame_color_render() { $options = get_option('pro_slider_settings'); $value = isset($options['thumbnail_frame_color']) ? $options['thumbnail_frame_color'] : '#FFFFFF'; echo "<input type='color' name='pro_slider_settings[thumbnail_frame_color]' value='" . esc_attr($value) . "'><p class='description'>Aktif olan küçük resmin etrafındaki çerçevenin rengini belirler.</p>";}
function pro_slider_autoplay_render() { $options = get_option('pro_slider_settings'); $autoplay_checked = isset($options['autoplay']) ? checked($options['autoplay'], 'on', false) : ''; $delay_value = isset($options['delay']) ? $options['delay'] : 5000; echo "<label><input type='checkbox' name='pro_slider_settings[autoplay]' " . $autoplay_checked . "> Otomatik başlatılsın mı?</label><br><input type='number' placeholder='Gecikme (ms)' name='pro_slider_settings[delay]' value='" . esc_attr($delay_value) . "'> Gecikme (milisaniye)";}
function pro_slider_effect_render() { $options = get_option('pro_slider_settings'); $value = isset($options['effect']) ? $options['effect'] : 'slide'; echo "<select name='pro_slider_settings[effect]'><option value='slide' ".selected($value, 'slide', false).">Kaydırma (Slide)</option><option value='fade' ".selected($value, 'fade', false).">Solma (Fade)</option><option value='cube' ".selected($value, 'cube', false).">Küp (Cube)</option><option value='coverflow' ".selected($value, 'coverflow', false).">Coverflow</option></select>";}
function pro_slider_show_arrows_render() { $options = get_option('pro_slider_settings'); $checked = isset($options['show_arrows']) ? checked($options['show_arrows'], 'on', false) : 'checked="checked"'; echo "<input type='checkbox' name='pro_slider_settings[show_arrows]' " . $checked . ">";}
function pro_slider_show_pagination_render() { $options = get_option('pro_slider_settings'); $checked = isset($options['show_pagination']) ? checked($options['show_pagination'], 'on', false) : 'checked="checked"'; echo "<input type='checkbox' name='pro_slider_settings[show_pagination]' " . $checked . ">";}
function pro_slider_show_thumbnails_render() { $options = get_option('pro_slider_settings'); $checked = isset($options['show_thumbnails']) ? checked($options['show_thumbnails'], 'on', false) : ''; echo '<label><input type="checkbox" name="pro_slider_settings[show_thumbnails]" ' . $checked . '> Küçük Resimli Navigasyonu Göster</label>';}
function pro_slider_thumbnail_count_render() { $options = get_option('pro_slider_settings'); $value = isset($options['thumbnail_count']) ? $options['thumbnail_count'] : 6; echo "<input type='number' name='pro_slider_settings[thumbnail_count]' value='" . esc_attr($value) . "' min='3' max='10'><p class='description'>Küçük resimler aktifse, aynı anda kaç tane gösterilecek?</p>";}

function pro_slider_sanitize_settings( $input ) {
    $old_settings = get_option( 'pro_slider_settings', array() );
    $new_settings = wp_parse_args( $input, $old_settings );
    $int_fields = ['slide_count', 'slider_height', 'delay', 'magazine_grid_category', 'thumbnail_count'];
    foreach ($int_fields as $field) { if ( isset( $new_settings[$field] ) ) { $new_settings[$field] = absint( $new_settings[$field] ); } }
    if ( isset( $input['slide_order'] ) ) { if ( isset( $new_settings['categories'] ) && is_array( $new_settings['categories'] ) ) { $new_settings['categories'] = array_map( 'absint', $new_settings['categories'] ); } else { $new_settings['categories'] = array(); } }
    if ( isset( $new_settings['skin'] ) ) { $allowed_skins = ['default', 'minimal-white', 'modern-dark', 'magazine-grid-light', 'magazine-grid-dark']; if ( ! in_array( $new_settings['skin'], $allowed_skins ) ) { $new_settings['skin'] = 'default'; } }
    if ( isset( $input['effect'] ) ) { $nav_checkboxes = ['autoplay', 'show_arrows', 'show_pagination', 'show_thumbnails']; foreach ($nav_checkboxes as $checkbox) { if ( !isset( $input[$checkbox] ) ) { unset($new_settings[$checkbox]); } } }
    return $new_settings;
}